#define DELAY0 10000 // Pause 0, 10 Sekunden
#define DELAY1 1000  // Pause 1, 1 Sekunde
#define DELAY2 2000  // Pause 2, 2 Sekunden
#define DELAY3 3000  // Pause 3, 3 Sekunden
int ledPinRotAuto = 7;     // Pin 7 steuert rote LED (Autoampel)
int ledPinGelbAuto = 6;    // Pin 6 steuert gelbe LED (Autoampel)
int ledPinGruenAuto = 5;   // Pin 6 steuert grüne LED (Autoampel)
int ledPinRotFuss = 3;     // Pin 3 steuert rote LED (Fußgängerampel)
int ledPinGruenFuss = 2;   // Pin 2 steuert grüne LED (Fußgängerampel)
int tasterPinAmpel = 8;    // Ampeltaster wird an Pin 8 angeschlossen
int tasterAmpelWert = LOW; // Variable für den Status des Ampeltasters

void ampelUmschaltung() {
   digitalWrite(ledPinGruenAuto, LOW); 
   digitalWrite(ledPinGelbAuto, HIGH); delay(DELAY3);
   digitalWrite(ledPinGelbAuto, LOW);
   digitalWrite(ledPinRotAuto, HIGH); delay(DELAY1);
   digitalWrite(ledPinRotFuss, LOW);
   digitalWrite(ledPinGruenFuss, HIGH); delay(DELAY0);
   digitalWrite(ledPinGruenFuss, LOW);
   digitalWrite(ledPinRotFuss, HIGH); delay(DELAY1);
   digitalWrite(ledPinGelbAuto, HIGH); delay(DELAY2);
   digitalWrite(ledPinRotAuto, LOW);
   digitalWrite(ledPinGelbAuto, LOW);
   digitalWrite(ledPinGruenAuto, HIGH);
}

void setup() {                
  pinMode(ledPinRotAuto, OUTPUT);      // Pin als Ausgang 
  pinMode(ledPinGelbAuto, OUTPUT);     // Pin als Ausgang 
  pinMode(ledPinGruenAuto, OUTPUT);    // Pin als Ausgang 
  pinMode(ledPinRotFuss, OUTPUT);      // Pin als Ausgang 
  pinMode(ledPinGruenFuss, OUTPUT);    // Pin als Ausgang 
  pinMode(tasterPinAmpel, INPUT);      // Pin als Eingang
  digitalWrite(ledPinGruenAuto, HIGH); // Anfangswerte (Autoampel grün)
  digitalWrite(ledPinRotFuss, HIGH);   // Anfangswerte (Fußgängerampel rot)
}

void loop() {
  // Ampeltasterstatus in Variable einlesen
  tasterAmpelWert = digitalRead(tasterPinAmpel);
  // Wurde Taster gedrückt, rufe Funktion auf
  if(tasterAmpelWert == HIGH)
    ampelUmschaltung();
}

